<?php

use App\Http\Controllers\AkunController;
use App\Http\Controllers\AutentikasiController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\HadiahController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\IndukController;
use App\Http\Controllers\KaryawanController;
use App\Http\Controllers\KasirController;
use App\Http\Controllers\KasriController;
use App\Http\Controllers\LaporanController;
use App\Http\Controllers\MemberController;
use App\Http\Controllers\OngkirController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\PengeluranController;
use App\Http\Controllers\PesanController;
use App\Http\Controllers\ProdukController;
use App\Http\Controllers\ProfilController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\StokController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\TransaksiController;
use App\Http\Controllers\TukarpoinController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/







// Route::get('/daftar', function () {
//     return view('user/daftar');
// });

// Route::get('/login-akun', function () {
//     return view('user/login');
// });

// Route::get('/detail', function () {
//     return view('user/detail');
// });

// Route::get('/keranjang', function () {
//     return view('user/keranjang');
// });

// Route::get('/checkout', function () {
//     return view('user/checkout');
// });

// Route::get('/myakun', function () {
//     return view('user/akun');
// });



Route::middleware(['guest'])->group(function () {
    Route::resource('/', \App\Http\Controllers\HomeController::class);
    Route::get('/home', [HomeController::class, 'index']);

    Route::get('/tentang', [HomeController::class, 'tentang']);
    Route::get('/layanan', [HomeController::class, 'layanan']);
    Route::get('/kontak', [HomeController::class, 'kontak']);
    Route::get('detail/{id}', [HomeController::class, 'detail']);
    Route::get('detail-item/{id}', [HomeController::class, 'detail_item']);
    Route::get('keranjang', [HomeController::class, 'keranjang']);

    Route::get('list-produk', [HomeController::class, 'produk']);
    Route::get('list-item', [HomeController::class, 'item']);

    Route::post('/add_cart', [OrderController::class, 'add_cart'])->name('cart.add');
    Route::post('/add_cart2', [OrderController::class, 'add_cart_detail'])->name('cart.add2');
    Route::post('qty-update', [OrderController::class, 'qty_update']);
    Route::post('hapus-cart', [OrderController::class, 'hapus_cart']);
    Route::get('view-cart', [OrderController::class, 'view_cart']);

    Route::get('daftar', [AkunController::class, 'daftar']);
    Route::post('/registe-member', [AkunController::class, 'registe_member']);

    Route::resource('/login', \App\Http\Controllers\AutentikasiController::class);
    Route::post('/login', [AutentikasiController::class, 'login'])->name('login');
    Route::post('kirim-pesan', [PesanController::class, 'kirim'])->name('pesan.kirim');
});

// member
Route::middleware(['auth:member'])->group(function () {
    Route::get('/logout-member', [AutentikasiController::class, 'logout']);
    Route::get('checkout', [OrderController::class, 'checkout']);
    Route::post('kirim_pesanan', [OrderController::class, 'order'])->name('kirim.pesanan');
    Route::get('invoice/{id}', [OrderController::class, 'invoice']);

    Route::post('/bukti_transfer', [OrderController::class, 'bukti_transfer'])->name('bukti.transfer');

    Route::resource('/akun', \App\Http\Controllers\AkunController::class);
    Route::get('data-pembayaran', [AkunController::class, 'pembayaran']);
    Route::get('setting-akun', [AkunController::class, 'setting_akun']);
    Route::post('update-setting', [AkunController::class, 'update_akun'])->name('akun.update');
    Route::get('setting-password', [AkunController::class, 'setting_password']);
    Route::post('update-password', [AkunController::class, 'update_password'])->name('update.password');
});

Route::middleware(['auth'])->group(function () {

    Route::get('/logout', [AutentikasiController::class, 'logout']);
    Route::get('password', [UserController::class, 'password']);
    Route::post('ubahpassword', [UserController::class, 'ubahpassword']);

    // admin
    Route::middleware('filteruser:1')->group(function () {
        Route::get('/dashboard', [DashboardController::class, 'index']);
        Route::post('/data-penjualan', [DashboardController::class, 'data_penjualan']);
        Route::post('/produk-terlaris', [DashboardController::class, 'produk_terlaris']);

        Route::resource('/user', \App\Http\Controllers\UserController::class);
        Route::put('edit-user', [UserController::class, 'update']);
        Route::get('delete-user/{id}', [UserController::class, 'destroy']);

        Route::get('/kategori', [IndukController::class, 'kategori'])->name('kategori');
        Route::post('/input_kategori', [IndukController::class, 'input_kategori'])->name('input_kategori');
        Route::put('edit-kategori', [IndukController::class, 'update_kategori']);
        Route::get('delete-kategori/{id}', [IndukController::class, 'hapus_kategori']);

        Route::get('/satuan', [IndukController::class, 'satuan'])->name('satuan');
        Route::post('/input_satuan', [IndukController::class, 'input_satuan'])->name('input_satuan');
        Route::put('edit-satuan', [IndukController::class, 'update_satuan']);
        Route::get('delete-satuan/{id}', [IndukController::class, 'hapus_satuan']);

        Route::resource('produk', \App\Http\Controllers\ProdukController::class);
        Route::get('/produk-tambah', [ProdukController::class, 'tambah']);
        Route::get('/view-kategori', [ProdukController::class, 'view_kategori']);
        Route::post('/simpan-kategori', [ProdukController::class, 'simpan_kategori']);
        Route::get('/view-satuan', [ProdukController::class, 'view_satuan']);
        Route::post('/simpan-satuan', [ProdukController::class, 'simpan_satuan']);
        Route::get('/produk-edit/{id}', [ProdukController::class, 'edit']);
        Route::post('/edit-produk', [ProdukController::class, 'update']);
        Route::post('/view-gambar', [ProdukController::class, 'gambar']);
        Route::post('/upload-gambar', [ProdukController::class, 'upload_gambar']);
        Route::post('/view-detail', [ProdukController::class, 'detail']);
        Route::delete('deleteall-produk', [ProdukController::class, 'destroy_all_produk']);
        Route::post('/cetak-barcode', [ProdukController::class, 'cetak_barcode']);
        Route::get('/download-format-produk', [ProdukController::class, 'download_produk']);
        Route::post('produk-import', [ProdukController::class, 'import_produk'])->name('produk.import');
        Route::get('/cetak-induk-produk', [ProdukController::class, 'cetak_induk']);
        Route::post('produk-diskon', [ProdukController::class, 'diskon_produk'])->name('produk.diskon');

        Route::resource('ongkir', \App\Http\Controllers\OngkirController::class);
        Route::put('edit-ongkir', [OngkirController::class, 'update']);
        Route::get('delete-ongkir/{id}', [OngkirController::class, 'destroy']);

        Route::get('/bank', [OngkirController::class, 'bank']);
        Route::post('/bank-tambah', [OngkirController::class, 'bank_tambah'])->name('bank.tambah');
        Route::put('edit-bank', [OngkirController::class, 'update_bank'])->name('bank.edit');
        Route::get('delete-bank/{id}', [OngkirController::class, 'destroy_bank']);

        Route::get('/data-member', [MemberController::class, 'data_member']);
        Route::delete('deleteall-member', [MemberController::class, 'destroy_all_member']);

        Route::get('/data-stok', [StokController::class, 'stok']);
        Route::delete('deleteall-stok', [StokController::class, 'destroy_all_stok']);

        Route::get('setting-banner-slideshow', [SettingController::class, 'banner']);
        Route::post('tambah-banner', [SettingController::class, 'tambah_banner'])->name('banner.tambah');
        Route::post('edit-banner', [SettingController::class, 'edit_banner'])->name('banner.edit');
        Route::get('delete-banner/{id}', [SettingController::class, 'destroy']);
        Route::post('detail-banner', [SettingController::class, 'detail_banner']);
        Route::post('status-banner', [SettingController::class, 'status_banner']);

        Route::get('struk-poin', [SettingController::class, 'struk_poin']);
        Route::post('edit-modul', [SettingController::class, 'edit_modul']);
        Route::get('coba-print', [SettingController::class, 'print']);

        Route::get('setting-diskon', [SettingController::class, 'diskon']);
        Route::post('tambah-diskon', [SettingController::class, 'tambah_diskon'])->name('diskon.tambah');
        Route::post('edit-diskon', [SettingController::class, 'edit_diskon'])->name('diskon.edit');
        Route::get('delete-diskon/{id}', [SettingController::class, 'destroy_diskon']);
        Route::post('status-diskon', [SettingController::class, 'status_diskon']);

        Route::get('penjualan', [TransaksiController::class, 'penjualan']);

        Route::delete('deleteall-penjualan', [TransaksiController::class, 'destroy_all_penjualan']);

        Route::resource('karyawan', \App\Http\Controllers\KaryawanController::class);
        Route::put('edit-karyawan', [KaryawanController::class, 'update'])->name('karyawan.update');
        Route::get('delete-karyawan/{id}', [KaryawanController::class, 'destroy']);

        Route::resource('hadiah-point', \App\Http\Controllers\HadiahController::class);
        Route::put('edit-hadiah', [HadiahController::class, 'update'])->name('hadiah-point.update');
        Route::get('delete-hadiah/{id}', [HadiahController::class, 'destroy']);
        Route::delete('deleteall-hadiah', [HadiahController::class, 'destroy_all_hadiah']);

        Route::resource('pesan', \App\Http\Controllers\PesanController::class);
        Route::put('edit-pesan', [PesanController::class, 'update'])->name('pesan.update');
        Route::get('delete-pesan/{id}', [PesanController::class, 'destroy']);
        Route::post('lihat-pesan', [PesanController::class, 'lihat_pesan']);
        Route::get('cek-pesan', [PesanController::class, 'cek_pesan']);
        Route::get('cek-data-pesan', [PesanController::class, 'cek_data_pesan']);
        Route::delete('deleteall-pesan', [PesanController::class, 'destroy_all_pesan']);

        Route::get('/profil-tentang', [ProfilController::class, 'index']);
        Route::get('/profil-layanan', [ProfilController::class, 'layanan']);
        Route::get('/profil-kontak', [ProfilController::class, 'kontak']);
        Route::put('/update-profil', [ProfilController::class, 'update'])->name('profil.edit');

        Route::get('/tukar-point', [TukarpoinController::class, 'tukarpoin']);
        Route::delete('/deleteall-penukaran', [TukarpoinController::class, 'destroy_all_penukaran']);

        Route::resource('supplier', \App\Http\Controllers\SupplierController::class);
        Route::put('edit-supplier', [SupplierController::class, 'update'])->name('supplier.edit');
        Route::get('delete-supplier/{id}', [SupplierController::class, 'destroy']);

        Route::resource('pengeluaran', \App\Http\Controllers\PengeluranController::class);
        Route::post('pengeluaran-tambah', [PengeluranController::class, 'pengeluaran_tambah']);
        Route::get('data-pengeluaran', [PengeluranController::class, 'data_pengeluaran']);
        Route::get('data-total', [PengeluranController::class, 'data_total']);
        Route::post('delete-pengeluaran', [PengeluranController::class, 'hapus']);
        Route::post('edit-jml-pengeluran', [PengeluranController::class, 'update']);
        Route::post('simpan-pengeluaran', [PengeluranController::class, 'simpan']);
        Route::delete('deleteall-pengeluaran', [PengeluranController::class, 'destroy_all_pengeluaran']);
        Route::post('detail-pengeluaran', [PengeluranController::class, 'detail_pengeluaran']);

        Route::get('laporan-penjualan', [LaporanController::class, 'penjualan']);
        Route::post('lap-penjualan', [LaporanController::class, 'lap_penjualan']);
        Route::post('export-lap-penjualan', [LaporanController::class, 'export_lap_penjualan']);
        Route::get('download/penjualan', [LaporanController::class, 'penjualan_download']);

        Route::get('laporan-pengeluaran', [LaporanController::class, 'pengeluaran']);
        Route::post('lap-pengeluaran', [LaporanController::class, 'lap_pengeluaran']);
        Route::post('export-lap-pengeluaran', [LaporanController::class, 'export_lap_pengeluaran']);
        Route::get('download/pengeluaran', [LaporanController::class, 'pengeluaran_download']);

        Route::get('laporan-stok', [LaporanController::class, 'stok']);
        Route::post('lap-stok', [LaporanController::class, 'lap_stok']);
        Route::post('export-lap-stok', [LaporanController::class, 'export_lap_stok']);
        Route::get('download/stok', [LaporanController::class, 'stok_download']);

        Route::get('laporan-keuangan', [LaporanController::class, 'keuangan']);
        Route::post('lap-keuangan', [LaporanController::class, 'lap_keuangan']);
        Route::post('export-lap-keuangan', [LaporanController::class, 'export_lap_keuangan']);
        Route::get('download/keuangan', [LaporanController::class, 'keuangan_download']);
    });

    Route::get('/cek-orderan', [KasirController::class, 'cek_orderan']);
    Route::get('/data-orderan', [KasirController::class, 'data_orderan']);

    Route::post('/view-detail-member', [MemberController::class, 'detail']);
    Route::post('detail-penjualan', [TransaksiController::class, 'detail_penjualan']);
    // kasir
    Route::middleware('filteruser:2')->group(function () {
        Route::resource('/kasir', \App\Http\Controllers\KasirController::class);
        Route::get('/laporan-invoice', [KasirController::class, 'laporan']);
        Route::post('/cek-invoice', [KasirController::class, 'cek_invoice']);
        Route::get('/cek-member-baru', [KasirController::class, 'cek_member']);
        Route::get('/data-member-baru', [KasirController::class, 'data_member']);

        Route::resource('member', \App\Http\Controllers\MemberController::class);
        Route::get('/member-tambah', [MemberController::class, 'tambah']);
        Route::post('/view-edit-member', [MemberController::class, 'edit_member']);
        Route::post('/update-member', [MemberController::class, 'update_member']);
        Route::post('/view-edit-ongkir', [MemberController::class, 'edit_ongkir']);
        Route::post('/update-ongkir-member', [MemberController::class, 'update_ongkir']);
        Route::post('/view-ongkir', [MemberController::class, 'ongkir']);
        Route::post('/cetak-kartu', [MemberController::class, 'cetak_kartu']);

        Route::resource('/stok', \App\Http\Controllers\StokController::class);
        Route::post('kode-produk', [StokController::class, 'kode_produk']);
        Route::post('cari-produk', [StokController::class, 'cari_produk']);
        Route::post('simpan-stok', [StokController::class, 'simpan_stok']);

        Route::resource('/transaksi', \App\Http\Controllers\TransaksiController::class);
        Route::post('simpan-keranjang', [TransaksiController::class, 'simpan_keranjang']);
        Route::get('tampil-keranjang', [TransaksiController::class, 'tampil_keranjang']);
        Route::get('tampil-nota', [TransaksiController::class, 'tampil_nota']);
        Route::post('delete-keranjang', [TransaksiController::class, 'destroy_keranjang']);
        Route::post('edit-qty', [TransaksiController::class, 'edit_qty']);
        Route::post('proses-tunggu', [TransaksiController::class, 'proses_tunggu']);
        Route::get('open-keranjang', [TransaksiController::class, 'open_keranjang']);
        Route::get('refund', [TransaksiController::class, 'refund']);
        Route::get('cek-harga', [TransaksiController::class, 'cek_harga']);
        Route::post('kode-member', [TransaksiController::class, 'kode_member']);
        Route::post('cari-member', [TransaksiController::class, 'cari_member']);
        Route::post('simpan-transaksi', [TransaksiController::class, 'simpan_transaksi']);
        Route::post('cari-transaksi', [TransaksiController::class, 'cari_transaksi']);
        Route::post('cetak-struk', [TransaksiController::class, 'cetak_struk']);
        Route::post('cetak-struk2', [TransaksiController::class, 'cetak_struk2']);
        Route::post('print-label', [TransaksiController::class, 'print_label']);
        Route::post('update-kurir', [TransaksiController::class, 'update_kurir']);

        Route::get('/order-online', [OrderController::class, 'order_online'])->name('order-online');
        Route::post('/cek-tansfer', [OrderController::class, 'cek_tansfer']);
        Route::post('/konfirmasi-pembayaran', [OrderController::class, 'konfirmasi_pembayaran']);
        Route::get('update-diterima/{id}', [OrderController::class, 'update_diterima']);
        Route::get('delete-order/{id}', [OrderController::class, 'destroy']);

        Route::resource('/tukar-poin', \App\Http\Controllers\TukarpoinController::class);
        Route::post('pilih-hadiah', [TukarpoinController::class, 'pilih_hadiah']);
        Route::post('/cari-member-item', [TukarpoinController::class, 'cari_member_item']);
        Route::post('/simpan-penukaran', [TukarpoinController::class, 'simpan_penukaran']);
        Route::post('cetak-penukaran', [TukarpoinController::class, 'cetak_penukaran']);
    });
});
